import { useState, useEffect } from 'react'
import { motion, AnimatePresence } from 'framer-motion'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  const images = [
    '/images/tour-1.jpg',
    '/images/tour-2.jpg',
    '/images/tour-3.jpg',
    '/images/tour-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container">
      <div className="slider-wrapper">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentIndex}
            className="slide"
            initial={{ opacity: 0, x: 100 }}
            animate={{ opacity: 1, x: 0 }}
            exit={{ opacity: 0, x: -100 }}
            transition={{ duration: 0.5 }}
            style={{ backgroundImage: `url(${images[currentIndex]})` }}
          >
            <div className="slide-overlay"></div>
          </motion.div>
        </AnimatePresence>

        <button className="slider-btn slider-btn-prev" onClick={goToPrevious}>
          <ChevronLeft size={28} strokeWidth={2.5} />
        </button>
        <button className="slider-btn slider-btn-next" onClick={goToNext}>
          <ChevronRight size={28} strokeWidth={2.5} />
        </button>

        <div className="slider-dots">
          {images.map((_, index) => (
            <button
              key={index}
              className={`dot ${index === currentIndex ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
              aria-label={`Go to slide ${index + 1}`}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

